﻿//////////////////////////////////////////////
// FileLogger.h
//
//////////////////////////////////////////////

/// Defines, macros --------------------------

#pragma once

/// Includes ---------------------------------

// nkLog
#include "../Dll/DllDefines.h"

#include "Logger.h"

// Standards
#include <fstream>

/// Class ------------------------------------
	
namespace nkLog
{
	class DLL_LOG_EXPORT FileLogger NK_FINAL : public Logger
	{			
		public :
		
			// Constructor, destructor
			FileLogger (StringView filePath) noexcept ;
			virtual ~FileLogger () ;

			// Getters
			StringView getOutputFilePath () const ;

			// Setters
			void setOutputFilePath (StringView path) ;

			// Actions
			virtual void log (StringView message, StringView className) override ;

		private :
		
			// Attributes
			// Output info
			String _filePath ;
			std::ofstream _file ;
	} ;
}